---
type: index
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# 20.0.1 - Form Classifications (index)

> Diagnostic classes over `Form` based on operational invariants and thresholds. Observational schema; not kernel.

---

## Classification Framework

| Class | Description | Key Diagnostic |
|-------|-------------|----------------|
| [[Stable Form (classification)]] | Fully stabilized across embedding layers | Persists under perturbation |
| [[Apparent Form (classification)]] | Looks coherent but hides instability | Hidden layer collapse |
| [[Collapsed Form (classification)]] | Fails stabilization completely | Difference dissipation |
| [[Pseudo Form (classification)]] | Performative/illusory coherence | No closure support |

Each classification provides:
- Technical and humane diagnostic criteria
- Scale-dependent manifestations
- Failure mode patterns
- Operational tests

---

## Core References

Primitives:
- [[Form]]
- [[Stabilization (Closure)]]
- [[Relation]]

Anchors:
- [[ε — Difference Resolution Quantum (constant)]]
- [[π — Closure Geometry Ratio (constant)]]
- [[e — Natural Transformation Rate (constant)]]
- [[φ — Asymmetric Stabilization Ratio (constant)]]
- [[c — Difference Propagation Limit (constant)]]

Modulators:
- [[∇S — Structure Differentiation Gradient (Sarkisian)]]
- [[λV — Void Resonance Threshold (Volozhina)]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]